<?php
if (!defined('ABSPATH')) exit;

function ptp_setup() {
  add_theme_support('title-tag');
  add_theme_support('post-thumbnails');
  add_theme_support('custom-logo', [
    'height' => 64,
    'width'  => 220,
    'flex-height' => true,
    'flex-width' => true,
  ]);
  add_theme_support('html5', ['search-form','comment-form','comment-list','gallery','caption','style','script']);
  add_theme_support('align-wide');
  add_theme_support('wp-block-styles');
  add_theme_support('editor-styles');

  register_nav_menus([
    'primary' => __('Primary Menu', 'panic-to-plate'),
    'footer'  => __('Footer Menu', 'panic-to-plate'),
  ]);
}
add_action('after_setup_theme', 'ptp_setup');

function ptp_assets() {
  // Google Fonts (polished default typography)
  wp_enqueue_style('ptp-google-fonts', 'https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Poppins:wght@600;700&display=swap', [], null);

  wp_enqueue_style('panic-to-plate-style', get_stylesheet_uri(), ['ptp-google-fonts'], '1.2.0');
  // Set CSS font vars to match loaded fonts
  wp_add_inline_style('panic-to-plate-style', ':root{--ptp-font-body:"Inter", ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial;--ptp-font-head:"Poppins", ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial;}');
}
add_action('wp_enqueue_scripts', 'ptp_assets');

// Convenience: menu fallback
function ptp_primary_menu() {
  if (has_nav_menu('primary')) {
    wp_nav_menu([
      'theme_location' => 'primary',
      'container' => false,
      'menu_class' => 'ptp-menu',
      'fallback_cb' => false,
      'depth' => 1,
    ]);
  } else {
    echo '<div class="ptp-menu">';
    echo '<a href="'.esc_url(home_url('/')).'">Home</a>';
    echo '<a href="'.esc_url(home_url('/pricing/')).'">Pricing</a>';
    echo '<a href="'.esc_url(home_url('/autopilot/')).'">Autopilot</a>';
    echo '<a href="'.esc_url(home_url('/rescue-mode/')).'">Rescue Mode</a>';
    echo '</div>';
  }
}
